# We want to change to pythonen but keep the cursor
# in the same position
# Find first line on screen and current line
line1=editor.getFirstVisibleLine()
myLine=editor.lineFromPosition(editor.getCurrentPos())
# Calculate how many lines down the screen we are
ldown=myLine-line1

# Get the current text
txt=editor.getText()
# Split into lines
txts=txt.splitlines(True)
# Setup output
txtout=''

# Move to end of doc to add stuff
#editor.documentEnd()
#editor.newLine()
#editor.clearAll()

# First establish the indent to use. We'll assume that the first indent
# used is the one we want and that we're using spaces
ind=4 # If we don't find an indent, we'll this as the default
lns=len(txts)
for ix in range(0, lns, 1):
    if (len(txts[ix]) - len(txts[ix].lstrip(' ')))>0:
        # Found an indent
        ind=len(txts[ix]) - len(txts[ix].lstrip(' '))
        break  # We've found an indent so we can stop

# Now we're going to parse the statements and create lists containing
# the indent Level and a list of all the code lines
ldSpaces=[]
isCode=[]
codeLines=[]
iLevel=[]
for ix in range(0, lns,1):
    # Number of lead spaces on this line
    # In the special case where this is a continuation line we just
    # make the lead spaces the same as the previous line
    if ix>0 and txts[ix-1].rstrip()!='' and txts[ix-1].rstrip()[-1]=="\\":
        ldSpaces.append(ldSpaces[-1])
    else:
        ldSpaces.append(len(txts[ix]) - len(txts[ix].lstrip(' ')))
    if not txts[ix] or not txts[ix].strip() or txts[ix].strip()[:1]=="#":
        # This is a null string, empty string or comment so set 0
        isCode.append(0)
    else:
        # This is a code line so set 1
        isCode.append(1)
        codeLines.append(ix)
    iLevel.append(int(ldSpaces[ix]/ind))

# Now we will create a list giving the index of the next code line
nextCodeLine=[]
for ix in range(0, lns,1):
    # Find the line number for the next line of code
    tmp = [i for i in codeLines if i > ix]
    # Check if there are no more code Lines
    if not tmp:
        # No more lines, set -1
        nextCodeLine.append(-1)
    else:
        nextCodeLine.append(tmp[0])
        
# Now we've got what we need to modify the code
# We'll use linesAdded to store extra lines up to the cursor line
linesAdded=0
for ix in range(0, lns,1):
    # if there are more code lines after this and if this is a code line 
    # and next code line is indented less, we write ends
    if isCode[ix]:
        #editor.addText(txts[ix])
        txtout = txtout + txts[ix]
        # Set next code level to next line of code or zero if no more code
        if nextCodeLine[ix]!=-1:
            nextCodeLevel=iLevel[nextCodeLine[ix]]
        else:
            nextCodeLevel=0
        # If outdent next, write the ends if needed (not for else/elif/etc level)
        if iLevel[ix]>nextCodeLevel:
            for iy in range(iLevel[ix], nextCodeLevel, -1):
                sPad= ind*(iy-1)
                # Add an end except for special else/elif/etc cases
                # if next code is else or elif we do one level less
                if (iy==nextCodeLevel+1) and (txts[nextCodeLine[ix]].lstrip(' ')[:4]=="else" \
                                          or txts[nextCodeLine[ix]].lstrip(' ')[:4]=="elif" \
                                          or txts[nextCodeLine[ix]].lstrip(' ')[:5]=="catch" \
                                          or txts[nextCodeLine[ix]].lstrip(' ')[:6]=="except" \
                                          or txts[nextCodeLine[ix]].lstrip(' ')[:7]=="finally"):
                    # don't need this one due to else/elif/etc
                    pass
                else:
                    #editor.addText(' '*sPad+"end\n")
                    txtout = txtout + ' '*sPad+"end\n"
                    if ix<myLine:
                        linesAdded +=1
    else:
        # Write non-code lines
        #editor.addText(txts[ix])
        txtout = txtout + txts[ix]
# Add a final end of line
#txtout = txtout + "\n"

# Delete the current content and replace
editor.clearAll()
editor.addText(txtout)

# now reposition the cursor
myNewLine = myLine + linesAdded
newLine1= myNewLine-ldown
# Set the first line and my new line
editor.setFirstVisibleLine(newLine1)
editor.gotoLine(myNewLine)
       
# The end of the script