""" Python 'pyn_ascii' Codec


Written by Marc-Andre Lemburg (mal@lemburg.com).

(c) Copyright CNRI, All Rights Reserved. NO WARRANTY.

"""
import codecs

### Codec APIs

class Codec(codecs.Codec):

    # Note: Binding these as C functions will result in the class not
    # converting them to methods. This is intended.
    encode = codecs.ascii_encode
    decode = codecs.ascii_decode

class IncrementalEncoder(codecs.IncrementalEncoder):
    def encode(self, input, final=False):
        return codecs.ascii_encode(input, self.errors)[0]

class IncrementalDecoder(codecs.IncrementalDecoder):
    def decode(self, input, final=False):
        #return codecs.ascii_decode(input, self.errors)[0]
        res = codecs.ascii_decode(input, self.errors)[0]
        respyn = convertPyn4Run(res)
        # debug print("res pyn=", respyn)
        return respyn
class StreamWriter(Codec,codecs.StreamWriter):
    pass

class StreamReader(Codec,codecs.StreamReader):
    pass

class StreamConverter(StreamWriter,StreamReader):

    encode = codecs.ascii_decode
    decode = codecs.ascii_encode

### encodings module API

def getregentry():
    return codecs.CodecInfo(
        name='pyn_ascii',
        encode=Codec.encode,
        decode=Codec.decode,
        incrementalencoder=IncrementalEncoder,
        incrementaldecoder=IncrementalDecoder,
        streamwriter=StreamWriter,
        streamreader=StreamReader,
    )

def convertPyn4Run(txt):
    # Setup output
    txtout=''

    # Split into lines
    txts=txt.splitlines(True)
    
    # Now we just copy each line to the output
    # If line starts with 'end', we'll replace with '#end'
    lns=len(txts)
    for ix in range(0, lns,1):
        if txts[ix].lstrip(' ')[:3]=="end":
            # replace the first 'end'
            txts[ix] = txts[ix].replace("end", "#end", 1)
        txtout = txtout + txts[ix]
    return txtout
 
